/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.player;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class PlayerPatronPetData {
    private boolean active = true;
    private boolean playAudio = true;
    private boolean spawnParticles = true;
    private UUID petID = null;

    public boolean getSpawnParticles() {
        return this.spawnParticles;
    }

    public void setSpawnParticles(boolean spawnParticles) {
        this.spawnParticles = spawnParticles;
    }

    public boolean getPlayAudio() {
        return this.playAudio;
    }

    public void setPlayAudio(boolean playAudio) {
        this.playAudio = playAudio;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public UUID getPetID() {
        return this.petID;
    }

    public void setPetID(UUID petID) {
        this.petID = petID;
    }

    public void copyFrom(PlayerPatronPetData source) {
        this.spawnParticles = source.spawnParticles;
        this.active = source.active;
        this.playAudio = source.playAudio;
        this.petID = source.petID;
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128379_("MutantMorePatronPetActive", this.active);
        compound.m_128379_("MutantMorePatronPetPlayAudio", this.playAudio);
        compound.m_128379_("MutantMorePatronPetSpawnParticles", this.spawnParticles);
        if (this.petID != null) {
            compound.m_128362_("MutantMorePatronPetID", this.petID);
        }
    }

    public void loadNBTData(CompoundTag compound) {
        this.active = compound.m_128471_("MutantMorePatronPetActive");
        this.playAudio = compound.m_128471_("MutantMorePatronPetPlayAudio");
        this.spawnParticles = compound.m_128471_("MutantMorePatronPetSpawnParticles");
        if (compound.m_128403_("MutantMorePatronPetID")) {
            this.petID = compound.m_128342_("MutantMorePatronPetID");
        }
    }
}

